﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="SoldStationGraphics.ascx.vb" Inherits="Web.SoldStationGraphics" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:UpdatePanel runat="server" Id="UpdatePanelGraficos" UpdateMode="Conditional">
<ContentTemplate>
 
<div class="block private">

    <div class="content ajax-tabs">

        <%-- PANEL PASO 1 - Selección de configuración o nueva --%>
        <asp:Panel ID="PanelConfiguracion" runat="server" Visible="false">
            <div class="reg-form">
	            <fieldset>

                    <%-- 0) Selección entre configuración pre-grabada en BD o nueva --%>
                    <div runat="server" id="divRadioButtonListConfig" visible="false">
                        <asp:Label CssClass="titol2" style="padding-top:10px;" runat="server"><%= CurrentContext.Translator.Translate("MSG_GRAPHIC_SELECT_AXIS_GRID")%></asp:Label>
		                <div class="row private">
                           <asp:RadioButtonList runat="server" ID="rdbConfiguracion" RepeatDirection="Horizontal"  CssClass="checksistema" style="position:relative; margin:0px auto; font-size:17px;" AutoPostBack="true" OnSelectedIndexChanged="rdbConfiguracion_SelectedIndexChanged"></asp:RadioButtonList>
		                </div>
                    </div>

                     <%-- 1) Selección configuración ya existente --%>
                    <div runat="server" id="divConfiguracion" visible="false">
                        <div class="row private">
                            <asp:Label ID="lblConfig" runat="server" CssClass="label" ><%= CurrentContext.Translator.Translate("MSG_GRAPHIC_CONFIG")%></asp:Label>
                            <asp:DropDownList ID="IdConfiguracionGrafico" runat="server" CssClass="input" AutoPostBack="true"></asp:DropDownList>
		                </div>
                        <div class="row">
                            <br />
                            <asp:LinkButton  ID="btnAbrir" runat="server" CssClass="btn"  OnClick="btnAbrir_Click" style="float:right;"><%= CurrentContext.Translator.Translate("MSG_GRAPHIC_OPEN_CONF")%></asp:LinkButton>
		                </div>
                    </div>

                    <%-- 2) Nueva configuración --%>
                    <div runat="server" id="divNuevaConfiguracion" visible="true">
                        <br />
                        <asp:Label  CssClass="titol2" runat="server"><%= CurrentContext.Translator.Translate("GRAPHIC_NAME_TITLE")%></asp:Label>
                        <div class="row private">
                            <asp:Label  runat="server" CssClass="label"><%= CurrentContext.Translator.Translate("GRAPHIC_NAME")%></asp:Label>
                            <asp:TextBox ID="NombreGrafico" type="" runat="server" CssClass="input" Text=""></asp:TextBox>
                        </div>
                        <br />
                        <asp:Label  CssClass="titol2" runat="server"><%= CurrentContext.Translator.Translate("GRAPHIC_AXIS_TITLE")%></asp:Label>
                        <div class="row private">                             
                            <asp:Label runat="server" CssClass="label"><%= CurrentContext.Translator.Translate("GRAPHIC_TEMPERATURE")%></asp:Label>
                            <asp:DropDownList ID="ValorMaxTemp" runat="server" CssClass="input" Width="75px" style="position:relative; float:right;"></asp:DropDownList>
                            <asp:Label runat="server" CssClass="label" style="position:relative; float:right; width:10px; margin-left:5px;">-</asp:Label>
                            <asp:DropDownList ID="ValorMinTemp" runat="server" CssClass="input" Width="75px" style="position:relative; float:right;"></asp:DropDownList>
                        </div>
                        <div class="row private">
                            <asp:Label  runat="server" CssClass="label"><%= CurrentContext.Translator.Translate("GRAPHIC_POWER_TITLE")%></asp:Label>
                            <asp:DropDownList ID="ValorMaxPotencia" runat="server" CssClass="input" Width="75px" style="position:relative; float:right;"></asp:DropDownList>
                            <asp:Label runat="server" CssClass="label" style="position:relative; float:right; width:10px; margin-left:5px;">-</asp:Label>
                            <asp:DropDownList ID="ValorMinPotencia" runat="server" CssClass="input" Width="75px" style="position:relative; float:right;"></asp:DropDownList>
                        </div>
                        <div class="row private">
                            <asp:Label  runat="server" CssClass="label"><%= CurrentContext.Translator.Translate("ADMIN_ENVIRONMENT_LBL_TEMP")%></asp:Label>
                            <asp:DropDownList runat="server" ID="ddlEscalaTemp" CssClass="input" AutoPostBack="true" OnSelectedIndexChanged="ddlEscalaTemp_SelectedIndexChanged">
                                <asp:ListItem Value="CELSIUS"></asp:ListItem>
                                <asp:ListItem Value="FAHRENHEIT"></asp:ListItem>
                            </asp:DropDownList>
                        </div>
                        <div class="row private">
                            <asp:Label  CssClass="label" runat="server"><%= CurrentContext.Translator.Translate("GRAPHIC_TIME_TITLE")%></asp:Label>
                            <asp:DropDownList ID="VentanaTiempo" runat="server" CssClass="input">
                                <asp:ListItem Text="10" Value="10" Selected="True"></asp:ListItem>
                                <asp:ListItem Text="30" Value="30"></asp:ListItem>
                                <asp:ListItem Text="60" Value="60"></asp:ListItem>
                                <asp:ListItem Text="120" Value="120"></asp:ListItem>
                                <asp:ListItem Text="300" Value="300"></asp:ListItem>
                            </asp:DropDownList>
                        </div>
                        <br />
                        <asp:Label  CssClass="titol2" runat="server"><%= CurrentContext.Translator.Translate("GRAPHIC_GRID_TITLE")%></asp:Label>
                        <div class="row private">
                            <asp:Label CssClass="label" runat="server"><%= CurrentContext.Translator.Translate("GRAPHIC_TEMPERATURE")%></asp:Label>
                            <asp:DropDownList ID="IncrTemp" runat="server" CssClass="input">
                                <asp:ListItem Text="25" Value="25"></asp:ListItem>
                                <asp:ListItem Text="50" Value="50"></asp:ListItem>
                                <asp:ListItem Text="75" Value="75"></asp:ListItem>
                                <asp:ListItem Text="100" Value="100"></asp:ListItem>
                            </asp:DropDownList>
                        </div>
                        <div class="row private">
                            <asp:Label  CssClass="label" runat="server"><%= CurrentContext.Translator.Translate("GRAPHIC_POWER_TITLE")%></asp:Label>
                            <asp:DropDownList ID="IncrPotencia" runat="server" CssClass="input">
                                <asp:ListItem Text="5" Value="5"></asp:ListItem>
                                <asp:ListItem Text="10" Value="10"></asp:ListItem>
                                <asp:ListItem Text="25" Value="25"></asp:ListItem>
                                <asp:ListItem Text="50" Value="50"></asp:ListItem>
                            </asp:DropDownList>
                        </div>
                        <div class="row private">
                            <asp:Label  CssClass="label" runat="server"><%= CurrentContext.Translator.Translate("GRAPHIC_TIME_MARK")%></asp:Label>
                            <asp:DropDownList ID="TiempoMarca" runat="server" CssClass="input">
                                <asp:ListItem Text="1" Value="1" Selected="True"></asp:ListItem>
                                <asp:ListItem Text="2" Value="2"></asp:ListItem>
                                <asp:ListItem Text="5" Value="5"></asp:ListItem>
                                <asp:ListItem Text="10" Value="10"></asp:ListItem>
                                <asp:ListItem Text="20" Value="20"></asp:ListItem>
                                <asp:ListItem Text="30" Value="30"></asp:ListItem>
                                <asp:ListItem Text="60" Value="60"></asp:ListItem>
                                <asp:ListItem Text="120" Value="120"></asp:ListItem>
                            </asp:DropDownList>
                        </div>
                        <div class="row">
                            <br />
                            <asp:CheckBox ID="chkGuardarConfig" Visible="false" runat="server"  CssClass="checksistema" style="float:left; font-size:17px; height:40px;" AutoPostBack="true" OnCheckedChanged="chkGuardarConfig_CheckedChanged"  />
                            <asp:LinkButton  OnClick="btnCargarConfiguracion_Click"  ID="btnCargarConfiguracion" runat="server" CssClass="btn"  style="float:right; margin-left:20px;"></asp:LinkButton> 
                            <asp:LinkButton  OnClick="btnCancelarConfiguracion_Click"  ID="btnCancelarConfiguracion" runat="server" CssClass="btn"  style="float:right;"></asp:LinkButton>                            
  		                </div>
                    </div>
	            </fieldset>
            </div>
        </asp:Panel>
        <%-- FIN PANEL PASO 1 --%>

        <%-- PANEL PASO 2 - Configuración parámetros adicionales gráfico --%>
        <asp:Panel ID="PanelConfiguracionSerie" runat="server" Visible="true" style="margin-bottom:25px;">
            <div class="reg-form">
	            <fieldset>
                    <div class="DockZone">
                        <div ID="DockConfOrigen" class="Dock active" style="width:100%;">

                            <!-- Cabecera -->
                            <div class="add-panel" >
                                <div class="subpanel">
				                    <span class="step">1</span>
                                    <span><%= CurrentContext.Translator.Translate("GRAPHIC_CONF_SERIE_TITLE")%></span>
                                </div>
                                <div class="actions origen">
                                   <a id="opsetting" class="settings black" style="cursor:pointer;" runat="server" onclick="javascript:openMenuAccions('.origen .menuaccions ul.actionsmenu.level1',event);">Settings</a>
                                   <asp:Menu ID="menuGrafic" SkinID="MenuAccions" runat="server" ItemWrap="True" Visible="true" OnMenuItemClick="menuGrafic_MenuItemClick">
                                   </asp:Menu>
		                         </div>
                            </div>
                            <!-- Zona de contenido -->
                            <div class="DockContent">

                                <!-- Panel con gridview de series-->
                                <asp:Panel id="panelSeries" runat="server" CssClass="jcf-scrollable" style="max-height:260px;overflow:auto;">
                                    <asp:Repeater ID="repeater_series" runat="server" OnItemCommand="repeater_series_ItemCommand">
                                        <HeaderTemplate>
                                            <ul class="estaciones-destino">
                                        </HeaderTemplate>
                                            <ItemTemplate>
                                                <li>
                                                    <div class="station">
                                                        <asp:LinkButton ID="lnkEstacion" runat="server" CssClass="procesos-nombre" Enabled="false" CommandArgument='<%# Eval("Nombre")%>'><%# Eval("NombreSerie")%></asp:LinkButton>
                                                        <asp:LinkButton  id="LnkDelete" CommandName="Delete" CssClass="remove" ToolTip='<%#  CurrentContext.Translator.Translate("ADMIN_ICON_DEL") %>' runat="server">Delete</asp:LinkButton>                                                              
                                                    </div>
                                                    <div class="ports">
                                                        <asp:LinkButton id="LnkEdit" CssClass="edit" CommandName="Edit" ToolTip='<%#  CurrentContext.Translator.Translate("ADMIN_ICON_EDIT") %>' runat="server" Visible='<%# Eval("VisibleEdit")%>'>Edit</asp:LinkButton> 
                                                        <asp:LinkButton id="LnkExport" CssClass="export" ToolTip='<%#  CurrentContext.Translator.Translate("ADMIN_ICON_EXPORT") %>' CommandName="Export" Visible='<%# Eval("VisibleExport")%>' runat="server" >Export</asp:LinkButton>
                                                        <asp:Label ID="LblSerie" runat="server" CssClass="procesos-puertos" Text='<%# Eval("InfoSerie")%>'></asp:Label>&nbsp;&nbsp;
                                                        <asp:LinkButton  id="LnkColor" CssClass="circulo" style='<%# Eval("bola")%>'  runat="server" Enabled="false"></asp:LinkButton> 
                                                    </div>
                                                </li>
                                                <asp:HiddenField ID="hdnIndexSerie" runat="server" Value='<%# Eval("IndexSerie")%>' />
                                            </ItemTemplate>
                                        <FooterTemplate>
                                            </ul>
                                        </FooterTemplate>
                                    </asp:Repeater>
                                </asp:Panel>

                                <!-- Panel con el árbol de configuración origen-->
                                <asp:Panel ID="panelNuevaSerie" runat="server" visible="false">
                                    <div class="row private">
                                        <asp:Label ID="lblNombre" runat="server" CssClass="label" ><%= CurrentContext.Translator.Translate("GRAPHIC_SERIE_NAME")%></asp:Label>
                                        <asp:TextBox ID="Nombre" type="" runat="server" CssClass="input" Text=""></asp:TextBox>
		                            </div>
                                    <div class="row private" id="divEstaciones" runat="server" visible="false">
                                        <asp:Label ID="lblEstaciones" runat="server" CssClass="label" Width="80px" ><%= CurrentContext.Translator.Translate("GRAPHIC_SERIE_STATION")%></asp:Label>
                                        <asp:DropDownList ID="Estaciones" runat="server" CssClass="input" AutoPostBack="true" OnSelectedIndexChanged="Estaciones_SelectedIndexChanged"></asp:DropDownList>
		                            </div>
                                    <div class="row private">
                                        <asp:Label ID="lblPuerto" runat="server" CssClass="label" Width="80px"><%= CurrentContext.Translator.Translate("GRAPHIC_SERIE_PORT")%></asp:Label>
                                        <asp:DropDownList ID="Puerto" runat="server" CssClass="input" AutoPostBack="true"  OnSelectedIndexChanged="Puerto_SelectedIndexChanged"></asp:DropDownList>
		                            </div>
                                    <div class="row private">
                                        <asp:Label ID="lblParametro" runat="server" CssClass="label" Width="80px" ><%= CurrentContext.Translator.Translate("GRAPHIC_SERIE_PARAM")%></asp:Label>
                                        <asp:DropDownList ID="Parametro" runat="server" CssClass="input">
                                            <asp:ListItem Value="TEMPERATURA"></asp:ListItem>
                                            <asp:ListItem Value="POTENCIA"></asp:ListItem>
                                        </asp:DropDownList>
		                            </div>
	                                <div class="row private">
                                        <asp:Label ID="lblColor" runat="server" CssClass="label" Width="80px" > <%= CurrentContext.Translator.Translate("GRAPHIC_SERIE_COLOR")%> </asp:Label>
                                        <asp:DropDownList ID="Color" runat="server" CssClass="input" AutoPostBack="true" OnSelectedIndexChanged="Color_SelectedIndexChanged">  
                                            <asp:ListItem value="#FF0000" style="background-color: Red;" Text="Red"></asp:ListItem>
                                            <asp:ListItem value="#808080" style="background-color: Gray;" Text="Gray"></asp:ListItem>
                                            <asp:ListItem value="#A9A9A9" style="background-color: DarkGray;" Text="DarkGray"></asp:ListItem>
                                            <asp:ListItem value="#0000FF" style="background-color: Blue;" Text="Blue"></asp:ListItem>  
                                            <asp:ListItem value="#7FFFD4" style="background-color: Aquamarine;" Text="Aquamarine"></asp:ListItem>                                     
                                            <asp:ListItem value="#000080" style="background-color: Navy;color: #FFFFFF;" Text="Navy"></asp:ListItem>
                                            <asp:ListItem value="#800080" style="background-color: Purple;color: #FFFFFF;" Text="Purple"></asp:ListItem>
                                            <asp:ListItem value="#FF1493" style="background-color: DeepPink;" Text="DeepPink"></asp:ListItem>
                                            <asp:ListItem value="#EE82EE" style="background-color: Violet;" Text="Violet"></asp:ListItem>
                                            <asp:ListItem value="#FFC0CB" style="background-color: Pink;" Text="Pink"></asp:ListItem>
                                            <asp:ListItem value="#006400" style="background-color: DarkGreen;color: #FFFFFF;" Text="DarkGreen"></asp:ListItem>
                                            <asp:ListItem value="#008000" style="background-color: Green;color: #FFFFFF;" Text="Green"></asp:ListItem>
                                            <asp:ListItem value="#9ACD32" style="background-color: YellowGreen;" Text="YellowGreen"></asp:ListItem>
                                            <asp:ListItem value="#FFFF00" style="background-color: Yellow;" Text="Yellow"></asp:ListItem>
                                            <asp:ListItem value="#FFA500" style="background-color: Orange;" Text="Orange"></asp:ListItem>
                                            <asp:ListItem value="#A52A2A" style="background-color: Brown;" Text="Brown"></asp:ListItem>
                                            <asp:ListItem value="#DEB887" style="background-color: BurlyWood;" Text="BurlyWood"></asp:ListItem>
                                            <asp:ListItem value="#F5F5DC" style="background-color: Beige;" Text="Beige"></asp:ListItem>  
                                            <asp:ListItem value="#FFFFFF" style="background-color: White;" Text="White"></asp:ListItem>
                                        </asp:DropDownList>
                                        <div id="divcirculo" class="bola" runat="server"></div>
		                            </div>   
                                    <div class="row">
                                        <br />
                                        <asp:LinkButton ID="btnCancelarModificarSerie" runat="server" CssClass="btn" OnClick="btnCancelarModificarSerie_Click"  style="float:right; margin-right:10px;"><%= CurrentContext.Translator.Translate("ADMIN_BTN_CANCEL")%></asp:LinkButton>
                                        <asp:LinkButton  ID="btnGuardarSerie" runat="server" CssClass="btn" OnClick="btnGuardarSerie_Click"  style="float:right; margin-right:10px;"><%= CurrentContext.Translator.Translate("ADMIN_GRAPHICS_CONFIG_SAVE")%></asp:LinkButton>
                                    </div>             
                                </asp:Panel>
                            </div>
                        </div>
                    </div>
	            </fieldset>
            </div>
        </asp:Panel>
        <%-- FIN PANEL PASO 2 --%>

        <div class="reg-form">
	        <fieldset>
                <div class="row" runat="server" id="divBotonesGrafico">
                  <asp:LinkButton  ID="btnConfigurarGrafico" runat="server" OnClick="btnConfigurarGrafico_Click"  CssClass="btn" ><%= CurrentContext.Translator.Translate("GRAPHIC_CONFIG")%></asp:LinkButton>
                  <asp:LinkButton  ID="btnGenerar" runat="server" CssClass="btn"  style="float:right; width:75px;" OnClick="btnGenerar_Click" ><%= CurrentContext.Translator.Translate("GRAPHIC_START")%></asp:LinkButton>
                  <asp:LinkButton  ID="btnParar" runat="server" CssClass="btn" OnClick="btnParar_Click"  style="float:right; margin-right:10px;width:75px;"><%= CurrentContext.Translator.Translate("GRAPHIC_STOP")%></asp:LinkButton>  
		        </div>  
            </fieldset>
            <br />
        </div> 

        <%-- PANEL PASO 3 - Gráfico --%>
        <asp:Panel ID="Grafico" runat="server" Visible="true">
            <asp:UpdatePanel runat="server" Id="UpdatePanelGrafico" UpdateMode="Conditional">
            <ContentTemplate>
                <telerik:RadHtmlChart runat="server" ID="LineChart" Transitions="false" Skin="Silk" EnableViewState="false">
                    <Appearance><FillStyle BackgroundColor="Transparent"></FillStyle></Appearance>
                    <ChartTitle><Appearance Align="Center" BackgroundColor="Transparent" Position="Top"></Appearance></ChartTitle>
                    <Legend><Appearance BackgroundColor="Transparent" Position="Bottom"></Appearance></Legend>
                  <PlotArea>
                        <Appearance>
                            <FillStyle BackgroundColor="Transparent"></FillStyle>
                        </Appearance>
                        <YAxis AxisCrossingValue="0" Color="Black" Reversed="false" Width="3" >
                            <LabelsAppearance DataFormatString="{0}" RotationAngle="0" Skip="0" Step="1"></LabelsAppearance>
                            <TitleAppearance Position="Center" RotationAngle="0" Text="Temp. ºC/ºF"></TitleAppearance></YAxis>
                            <AdditionalYAxes>
                                <telerik:AxisY Name="AdditionalAxis" Color="Black" Width="3" AxisCrossingValue="0" >
                                <TitleAppearance Text="Potencia (%)"><TextStyle Color="Black" /></TitleAppearance>
                                <LabelsAppearance><TextStyle Color="Black" /></LabelsAppearance>
                                </telerik:AxisY>
			                </AdditionalYAxes>
                            <XAxis Color="black" Reversed="false" BaseUnit="Seconds">
                                <MinorGridLines Visible="false" />
                                <MajorGridLines Visible="false" />
                                <Items></Items>
                                <LabelsAppearance DataFormatString="{0}" RotationAngle="0" Skip="0" Step="1"></LabelsAppearance>
                                <TitleAppearance Position="Center" RotationAngle="0" Text="Tiempo (s)"></TitleAppearance>
                            </XAxis>
                     </PlotArea>
                </telerik:RadHtmlChart>
                <asp:Label ID="lblSegundos" runat="server" CssClass="contador_tiempo" Text=""></asp:Label>
                 
                 <div class="reg-form" id="divPaginacionGrafico" runat="server">
	                <fieldset>
                        <div class="row">
                            <asp:Button ID="btnAnteriorVentana" runat="server" CssClass="btn" Text="<<" style="float:left; width:55px;"  />
                            <asp:Button ID="btnAnteriorValor" runat="server" CssClass="btn" Text="<" style="float:left; margin-left:10px; width:55px;" />  
                            <asp:Button ID="btnSiguienteVentana" runat="server" CssClass="btn" Text=">>" style="float:right; width:55px;" />
                            <asp:Button ID="btnSiguienteValor" runat="server" CssClass="btn" Text=">" style="float:right; margin-right:10px; width:55px;"  />
                        </div>  
                    </fieldset>
                </div> 
                
                <!--- Controles ocultos y timer-->     
                <asp:HiddenField ID="hdnTicks" runat="server" Value="0"/>
                <asp:HiddenField ID="hdnTicks_ant" runat="server" Value="0"/>
                <asp:HiddenField ID="hdnHoraInicioEjecucion" runat="server" Value="0"/>
                <asp:HiddenField ID="hdnTotalDatosRecogidos" runat="server" Value="0"/>
                <asp:HiddenField ID="hdnTiempoMarca" runat="server" Value="0"/>
                <asp:HiddenField ID="hdnEscalaTemp" runat="server" Value="CELSIUS"/>
                <asp:HiddenField ID="hdnCambioEscala" runat="server" Value="0"/>
                <asp:HiddenField ID="hdnVentanaTiempo" runat="server" Value="0" />
                <asp:HiddenField ID="hdn_indice_export" runat="server" />
                <asp:HiddenField ID="hdnEdicion" runat="server" />
                <asp:Timer ID="TimerUpdateGrafico" runat="server" Interval="100" OnTick="TimerUpdateGrafico_Tick" Enabled="false"></asp:Timer>

                <!-- control ventanas desplazamiento -->
                <asp:HiddenField ID="hdnVentanaTiempoMax" runat="server" />
                <asp:HiddenField ID="hdnVentanaTiempoMin" runat="server" />
                <asp:HiddenField ID="hdnVentanaFinal" runat="server" /> 

            </ContentTemplate>  
            <Triggers>
                <asp:AsyncPostBackTrigger ControlID="TimerUpdateGrafico" EventName="Tick" />
            </Triggers>
            </asp:UpdatePanel>  
               
        </asp:Panel>
        <%-- FIN PANEL PASO 3 --%>

    </div> 
</div>  
    
<!--Panel de errores del formulario de registro -->
<asp:Panel ID="PanelErrores" runat="server" Style="display:none;" CssClass="error-message">
    <div class="holder">
        <asp:Literal ID="infoerrores" runat="server"></asp:Literal>
        <asp:LinkButton ID="btnAceptar_PanelEntradaDatos" runat="server" CssClass="btn"  OnClick="btnAceptar_PanelEntradaDatos_Click" ><%= CurrentContext.Translator.Translate("ADMIN_BTN_DELETE_OK")%></asp:LinkButton>
        <a id="btnCancelar_PanelErrores" href="#" runat="server" class="btn"><%= CurrentContext.Translator.Translate("ADMIN_BTN_CLOSE")%></a>
	</div>
</asp:Panel>
    
<!--Panel formulario de envio mail -->
<asp:Panel ID="PanelMail" runat="server" Style="display:none" CssClass="error-message">
<asp:UpdatePanel runat="server" Id="UpdatePanelMail" UpdateMode="Conditional">
    <ContentTemplate>
        <div class="holder">
            <asp:TextBox ID="TbA" runat="server"  Width="280px" style="margin:0 auto;" placeholder="Mail destinatario:"></asp:TextBox>
            <br />
            <asp:TextBox ID="TbAsunto" runat="server"  Width="280px" style="margin:0 auto;" placeholder="Asunto:"></asp:TextBox>
            <br />
            <telerik:RadTextBox  ID="TbCuerpo" runat="server" Width="280px" Height="120px" style='margin:0 auto; font-size:16px !important;' TextMode="MultiLine"></telerik:RadTextBox> 
            <br /><br />
            <asp:Button ID="btnEnviarMail" runat="server" OnClick="btnEnviarMail_Click" class="btn"></asp:Button>
            <asp:Button ID="btnEnviarCancel" runat="server" OnClick="btnEnviarCancel_Click" class="btn"></asp:Button>
        </div>
    </ContentTemplate> 
    <Triggers>
        <asp:AsyncPostBackTrigger ControlID="btnEnviarMail" EventName="Click" />
        <asp:AsyncPostBackTrigger ControlID="btnEnviarCancel" EventName="Click" />
    </Triggers>
</asp:UpdatePanel> 

<!-- Controles ajax --> 
<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderPanelMail" TargetControlID="UpdatePanelMail" BehaviorID="animation" runat="server">    
<Animations>
    <OnUpdated>
        <Sequence>
            <ScriptAction Script="UnlockScreen();" />
        </Sequence>
    </OnUpdated>
</Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>

</asp:Panel>

<!--Panel formulario de exportación -->
<asp:Panel ID="PanelExport" runat="server" Style="display:none;" CssClass="error-message">
<asp:UpdatePanel runat="server" Id="UpdatePanelExport" UpdateMode="Conditional">
<ContentTemplate>

    <div class="holder" >
        <asp:Literal ID="Literal1" runat="server"></asp:Literal>
        <asp:DropDownList ID="CBFormatos" runat="server" Width="200px" CssClass="combo" AutoPostBack="true" OnSelectedIndexChanged="CBFormatos_SelectedIndexChanged">               
        </asp:DropDownList>
        <br /><br />
        <asp:Label ID="LitFormatos" runat="server" style="min-height:60px;font-size:16px; overflow:auto;"></asp:Label>
        <br /><br />  
        <asp:LinkButton ID="btnExportAceptar" runat="server" OnClick="btnExportAceptar_Click"  class="btn"><%= CurrentContext.Translator.Translate("GRAPHIC_EXPORT_OK")%></asp:LinkButton>
        <asp:LinkButton ID="btnExportCancelar" runat="server" OnClick="btnExportCancelar_Click" class="btn"><%= CurrentContext.Translator.Translate("GRAPHIC_EXPORT_EXIT")%></asp:LinkButton>
        <div id="PostProceso" runat="server" style="display:none">
            <asp:LinkButton ID="LinkSampleLbr" runat="server"  OnClick="LinkSampleLbr_Click"  class="btn" Visible="false">Test ejemplo LBR</asp:LinkButton>
            <asp:LinkButton ID="LinkTestLbr" runat="server"  OnClick="LinkTestLbr_Click"  class="btn"  Visible="false">Test LBR</asp:LinkButton>
            <asp:LinkButton ID="LinkExport" runat="server"  class="btn"><%= CurrentContext.Translator.Translate("GRAPHIC_EXPORT_FILE")%></asp:LinkButton>
            <asp:LinkButton ID="LinkButtonMail" runat="server" OnClick="btnMail_Click"  class="btn"><%= CurrentContext.Translator.Translate("GRAPHIC_EXPORT_MAIL")%></asp:LinkButton>
            <asp:LinkButton ID="LinkButtonCancel" runat="server" OnClick="btnCancelar_Click"  class="btn"><%= CurrentContext.Translator.Translate("GRAPHIC_EXPORT_EXIT")%></asp:LinkButton>
        </div>
    </div>

    <!-- controles ajax-->
    <asp:HiddenField ID="hdnfileExport" runat="server" /> 
    
</ContentTemplate>  
</asp:UpdatePanel>
</asp:Panel>

<!-- controles ajax-->
<ajaxToolkit:ModalPopupExtender ID="MPE_PanelErrores" runat="server" TargetControlID="hdnPanelErrores" PopupControlID="PanelErrores" BackgroundCssClass="" CancelControlID="btnCancelar_PanelErrores" DropShadow="false" PopupDragHandleControlID=""/>
<ajaxToolkit:ModalPopupExtender ID="MPE_Mail" runat="server"  TargetControlID="hdnPanelMail" PopupControlID="PanelMail" BackgroundCssClass="" CancelControlID="" DropShadow="false" PopupDragHandleControlID=""/>
<ajaxToolkit:ModalPopupExtender ID="MPE_PanelExport" runat="server"  TargetControlID="hdnPanelExport" PopupControlID="PanelExport" BackgroundCssClass="" CancelControlID="" DropShadow="false" PopupDragHandleControlID=""/>

<!-- controles ocultos-->
<asp:HiddenField ID="hdnPanelErrores" runat="server" />
<asp:HiddenField ID="hdnModo" runat="server" Value="ESTACION" />
<asp:HiddenField ID="hdn_ip_servidor" runat="server" />
<asp:HiddenField ID="hdn_id_estacion" runat="server" />
<asp:HiddenField ID="hdn_nombre_estacion" runat="server" />
<asp:HiddenField ID="hdn_indexserie_modif" runat="server" Value="" />
<asp:HiddenField ID="hdnPanelStation" runat="server" />
<asp:HiddenField ID="hdnPanelMail" runat="server" />
<asp:HiddenField ID="hdnPanelExport" runat="server" />

</ContentTemplate>
</asp:UpdatePanel>

<!-- Controles ajax -->     
<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderGraficos" TargetControlID="UpdatePanelGraficos" BehaviorID="animation" runat="server">
<Animations>
    <OnUpdated>
        <Sequence>
            <FadeIn AnimationTarget="PanelErrores" Duration="0.15" minimumOpacity=".3"  />
             <EnableAction AnimationTarget="btnCancelar_PanelErrores" Enabled="true" />
            <ScriptAction Script="" />
        </Sequence>
    </OnUpdated>
</Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>

<!-- Update Progress -->
<asp:UpdateProgress ID="UpdateProgressBotones1" runat="server" AssociatedUpdatePanelID="UpdatePanelMail" DisplayAfter="0">
    <ProgressTemplate>
        <asp:Image ID="img_ajax_loading_MenuStation1" runat="server" ImageUrl="~/images/ajax-loading.gif"  CssClass="ajax_loading_centered" style="z-index:100002;"  />
    </ProgressTemplate>
</asp:UpdateProgress>

